<?php namespace Modules\Account\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use Auth;
use Exception;
use Guid;
use Hash;
use Input;
use Modules\Account\Models\Role;
use Modules\Account\Models\Session;
use Modules\Account\Models\User;
use Request;
use SMS;
use Str;
use Validator;

class RegisterController extends ApiController {
    public function SignUp() {
        $validator = Validator::make(Request::all(), [
            'mail' => 'bail|required|unique:xxsecurity_user,xusername|max:255',
            'password' => 'required|min:6',
        ]);

        if ($validator->fails()) {
            throw new Exception(implode(",", $validator->messages()->all()), 1);
        }

        $mail = Input::get('mail');
        $password = Input::get('password');
        $device = Input::get('device');

        $role = Role::where('xname', '=', 'Customer')->first();
        $user = User::create([
            'xusername' => $mail,
            'xpassword' => Hash::make($password),
        ]);

        $user->userInfo()->create(['xmobile' => $mail]);
        $user->attachRole($role);

        $dbSession = new Session;
        $dbSession->xuserid = $user->xuserid;
        $dbSession->xuuid = Guid::create();
        $dbSession->xdeviceid = self::GetDeviceId($device);
        $dbSession->save();

        Auth::login($user);
        return response()->json(['mail' => $user->xusername, 'session' => $dbSession->xuuid]);
    }

    public function SignIn() {
        $validator = Validator::make(Request::all(), [
            'mail' => 'required',
            'password' => 'required',
        ]);

        if ($validator->fails()) {
            throw new Exception(implode(",", $validator->messages()->all()), 1);
        }

        $mail = Input::get('mail');
        $password = Input::get('password');
        $device = Input::get('device');

        if (Auth::attempt(['xusername' => $mail, 'password' => $password], true)) {
            $user = Auth::user();
            $deviceId = self::GetDeviceId($device);
            $dbSession = Session::where('xuserid', $user->xuserid)->where('xdeviceid', $deviceId)->first();
            if (!$dbSession) {
                $dbSession = new Session;
            }
            $dbSession->xuserid = $user->xuserid;
            $dbSession->xuuid = Guid::create();
            $dbSession->xdeviceid = $deviceId;
            $dbSession->save();

            return response()->json([
                'mail' => $user->xusername,
                'session' => $dbSession->xuuid,
                'info' => [
                    'name' => $user->userInfo->xname . ' ' . $user->userInfo->xfamily,
                    'picLink' => '/pic',
                    'phone' => $user->xusername,
                    'education' => 'education',
                ],
            ]);
        }

        throw new Exception("نام کاربری یا رمز عبور اشتباه است.", 1);

    }

    public function GetSession() {
        $validator = Validator::make(Request::all(), [
            'mail' => 'required',
        ]);

        if ($validator->fails()) {
            throw new Exception(implode(",", $validator->messages()->all()), 1);
        }

        $mail = Input::get('mail');
        $device = Input::get('device');
        $user = User::where('xusername', trim($mail))->first();
        if (!$user) {
            $role = Role::where('xname', '=', 'Customer')->first();
            $user = User::create([
                'xusername' => $mail,
                'xpassword' => Hash::make(Str::random(10)),
            ]);

            $user->userInfo()->create(['xmobile' => $mail]);
            $user->attachRole($role);
        }

        $deviceId = self::GetDeviceId($device);
        $dbSession = Session::where('xuserid', $user->xuserid)->where('xdeviceid', $deviceId)->first();
        if (!$dbSession) {
            $dbSession = new Session;
            $dbSession->xuserid = $user->xuserid;
            $dbSession->xuuid = Guid::create();
            $dbSession->xdeviceid = $deviceId;
            $dbSession->save();
        }
        return response()->json(['mail' => $user->xusername, 'session' => $dbSession->xuuid]);

    }

    public function SetInfo() {
        $validator = Validator::make(Request::all(), [
            'session' => 'required',
        ]);

        if ($validator->fails()) {
            throw new Exception(implode(",", $validator->messages()->all()), 1);
        }

        $session = Input::get('session');

        $dbSession = Session::where('xuuid', $session)->first();
        if (!$dbSession) {
            throw new Exception("اطلاعات ارسال شده معتبر نیست", 1);
        }

        $user = User::find($dbSession->xuserid);
        if (!$user) {
            throw new Exception("لطفا دوباره وارد شوید", 1);
        }

        $user->userInfo->xname = Input::get('name');
        $user->userInfo->xmobile = Input::get('phone');
        $user->userInfo->save();
        $user->save();

        return response()->json(['result' => true]);
    }

    public function GetInfo() {
        $validator = Validator::make(Request::all(), [
            'session' => 'required',
        ]);

        if ($validator->fails()) {
            throw new Exception(implode(",", $validator->messages()->all()), 1);
        }

        $session = Input::get('session');

        $dbSession = Session::where('xuuid', $session)->first();
        if (!$dbSession) {
            throw new Exception("اطلاعات ارسال شده معتبر نیست", 1);
        }

        $user = User::find($dbSession->xuserid);
        if (!$user) {
            throw new Exception("لطفا دوباره وارد شوید", 1);
        }

        return response()->json([
            'name' => $user->userInfo->xname . ' ' . $user->userInfo->xfamily,
            'picLink' => '/pic',
            'phone' => $user->xusername,
            'education' => 'education',
        ]);
    }

    public function ForgotPassword() {
        $mail = Input::get('mail');
        $device = Input::get('device');
        $user = User::where('xusername', trim($mail))->first();
        if (!$user) {
            throw new Exception("ایمیل درخواست شده وجود ندارد. لطفا ابتدا ثبت نام کنید.", 1);
        }

        $newPassword = Str::random(10);
        $user->xpassword = Hash::make($newPassword);
        $user->save();

        $mobile = $user->xusername;
        $passwordResetText = "رمز عبور جدید شما {pass} می باشد.";
        $text = str_replace('{pass}', $newPassword, $passwordResetText);
        $smsResponse = SMS::send($text, $mobile);

        return response()->json([]);
    }

    public function GetUserId() {
        $session = Input::get('session');
        $dbSession = Session::where('xuuid', $session)->first();
        if (!$dbSession) {
            throw new Exception("اطلاعات ارسال شده معتبر نیست", 1);
        }

        $user = User::find($dbSession->xuserid);
        if (!$user) {
            throw new Exception("لطفا دوباره وارد شوید", 1);
        }

        return response()->json([$user->xuserid]);
    }

    public function GetDeviceId($device) {
        return 1;
    }
}
