<?php namespace Modules\Account\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Input;
use Modules\Account\Models\Role;
use Modules\Account\Models\Permission;
use Lib;
use Modules\Account\Models\ItemPermission;

class UserGroupController extends BackendController {
    public $title = "language.users group management";

    public function index() {
        $this->field[] = ['php' => 'echo  $item["xname"];', 'name' => trans('language.group'), 'css' => 'width: 10%', 'sortable' => 'xname'];

        $this->list = Role::getResult();
        $this->paginate();
        
        $this->layout->content->listBtn['showRolePermission'] = true;
        
    }

    public function create($id = 0) {
        $this->layout->title = 'language.usergroup';
    }

    public function edit($id) {
        $this->layout->content->list = Role::find($id);
        $this->layout->title = 'language.usergroup';

    }

    public function store($id) {
        $frm = Input::get('frm');
        $role = Role::updateById($frm, $id);
        if(!$id){
            $role->permission()->create(['xmodule' => 'Home', 'xcontroller'=>'Home', 'xaction' => 'index', 'xtype' => 'edit']);
        }
        die('[[OK]]');
    }

    public function editRolePermission($id){
        $this->layout->storeMethod = 'storeRolePermission';
        $this->layout->content = view('account::admin.edit.rolePermission');
        $modules = \DB::table("admin_module")->whereNotNull('url')->orderBy('order','desc')->get();
        $permission = Permission::where('xroleid',$id)->get();
        $permis = [];
        foreach($modules as $module){
            $path = Lib::getPath($module['url'], ['section' => 'Admin']);
            $per = $permission->first(function($item) use ($path){
                return $item->xcontroller == $path['controller'];
            });
            if($per){
                switch ($per->xaction) {
                    case 'edit': $permis[$module['id']] = 1; break;
                    case 'store': $permis[$module['id']] = 2; break;
                    case 'create': $permis[$module['id']] = 3; break;
                    case 'delete': $permis[$module['id']] = 4; break;
                    case 'any': $permis[$module['id']] = 5; break;
                    case 'block': $permis[$module['id']] = 0; break;
                    default: $permis[$module['id']] = 0; break;
                }
            }else{
                $permis[$module['id']] = 0;
            }
        }
        $this->layout->content->roleId = $id;
        $this->layout->content->modules = $modules ?: [1];
        $this->layout->content->permission = $permis ?: [1];
        $this->layout->title = 'role permission';
    }

    public function storeRolePermission($id) {
        $count = Role::where('xroleid',$id)
            ->where('xname','not like','admin')
            ->where('xname','not like','programmer')
            ->where('xname','not like','customer')
            ->count();
        
        if(!$count)
            return;

        $frm = Input::get('frm');
        $modules = \DB::table("admin_module")->whereNotNull('url')->orderBy('order','desc')->get();
        Permission::where('xroleid',$id)->delete();
        foreach($modules as $val){
            $actionType = $frm[$val['id']];
            if(!$actionType) continue;
            $path = Lib::getPath($val['url'], ['section' => 'Admin']);
            $action = 'block';
            switch ($actionType) {
                case 1: //view
                    $action = 'edit'; break;
                case 2: //edit
                    $action = 'store'; break;    
                case 3: //create
                    $action = 'create'; break;
                case 4: //delete
                    $action = 'delete'; break;
                case 5: //any
                    $action = 'any'; break;
                default:
                    $action = 'block'; break;
            }
            $params = [
                'xroleid' => $id,
                'xmodule' => config('route.' . trim($path['controller'])),
                'xcontroller' => $path['controller'],
                'xaction' => $action,
                'xtype' => 'edit'
            ];
            
            $permissions = Permission::updateById($params);
        }
        
        
        die('[[OK]]');
    }

    public function editRolePermissionLimited($id,$roleId){
        $this->layout->storeMethod = 'storeRolePermissionLimited';
        $this->layout->content = view('account::admin.edit.userPermission');
        $modules = \DB::table("admin_module")->where('id',$id)->first();
        if(!$modules['namespace']) return;
        $items = $modules['namespace']::pluck('title', 'id');
        $permis = [];
        $this->layout->content->typeList = ItemPermission::$typeList;
        $this->layout->content->permissions = ItemPermission::where('module_id',$id)->where('role_id',$roleId)->get();
        $this->layout->content->itemsList = $items;
        $this->layout->content->role = $roleId;
        $this->layout->content->module = $id;
        $this->layout->title = 'role permission';
    }

    public function storeRolePermissionLimited($id) {
        
        $frm = Input::get('list');
        $module = Input::get('module');
        $role = Input::get('role');

        $deleteed = ItemPermission::where('role_id',$role)->where('module_id',$module)->delete();
        
        foreach ($frm as $key => $value) {
            $item = $value;
            $item['role_id'] = $role;
            $item['module_id'] = $module;
            $permissions = ItemPermission::updateById($item);
        }
        die('[[OK]]');
    }

    public function delete($id) {
        Role::remove($id);
        die('[[OK]]');
    }

    public function setCombo() {
        $usergrouplist = Role::getResult()->pluck('xname');
        //$newUserGroup = [];
        //$this->layout->toolbar['hideCreate'] = ($newUserGroup ? false : true);
        //$this->layout->content->newgrouplist = $newUserGroup;
    }
}