<?php namespace Modules\Account\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Auth;
use Config;
use Crypt;
use FarsiLib;
use File;
use Hash;
use Input;
use Modules\Account\Exports\UsersExport;
use Modules\Account\Models\Role;
use Modules\Account\Models\User;
use Modules\Account\Models\UserInfo;
use Modules\Account\Models\ItemPermission;
use Modules\Author\Models\Author;
use Request;
use Session;
use Lib;

class UserController extends BackendController {
    public $title = "language.users";

    //## list
    public function index() {
        $this->field[] = ['php' => 'echo \'<div style="text-align: center;"><img src="/pic/user/\' . $item["xuserid"] . "w30h40c1/". rand(1000, 100000) . ".png?nocache=1" . \'" alt="" /></div>\';',
            'name' => trans('language.picture'), 'css' => 'width: 3%'];
        //$this->field[] = ['php' => 'echo $item["xgroupname"];', 'name' => trans('language.group'), 'css' => 'width: 10%', 'sortable' => 'xroleid'];
        $this->field[] = ['php' => 'echo \'<div style="direction: ltr;">\' . $item["xusername"] . "</div>";', 'name' => trans('language.username'), 'css' => 'width: 10%', 'sortable' => 'xusername'];
        $this->field[] = ['php' => 'echo $item["xname"];', 'name' => trans('language.name'), 'css' => 'width: 10%', 'sortable' => 'xname'];
        $this->field[] = ['php' => 'echo $item["xfamily"];', 'name' => trans('language.family'), 'css' => 'width: 10%', 'sortable' => 'xfamily'];
        $this->field[] = ['php' => 'echo \'<div style="direction: ltr;">\' . $item["xemail"] . "</div>";', 'name' => trans('language.email'), 'css' => 'width: 10%', 'sortable' => 'xemail'];
        $this->field[] = ['php' => 'echo \'<div style="direction: ltr;">\' . FarsiLib::convertDigit($item["xmobile"]) . "</div>";', 'name' => trans('language.mobile'), 'css' => 'width: 10%', 'sortable' => 'xmobile'];
        $this->field[] = ['php' => 'echo \'<div class="text-center">\' . ($item["xcreationdate"] != "0000-00-00 00:00:00" ? FarsiLib::g2jDate($item["xcreationdate"], true) : trans("language.unknown")) .
            "</div>";', 'name' => trans('language.register date'), 'css' => 'width: 10%', 'sortable' => 'xcreationdate'];
        $this->field[] = ['php' => 'if ($item["xuser_status"] == "active") echo \'<div class="text-center"><span class="label label-sm label-success">\' . trans("language.active") . "</span></div>";
            elseif ($item["xuser_status"] == "deleted") echo \'<div class="text-center"><span class="label label-sm label-danger">\' . trans("language.deleted") . "</span></div>";
            else echo \'<div class="text-center"><span class="label label-sm label-default">\' . trans("language.inactive") . "</span></div>"; ',
            'name' => trans('language.status'), 'css' => 'width: 2%', 'sortable' => 'xuser_status'];

        $this->list = User::getResult()
            ->groupBy('u.xuserid');
            //->having('xgroupname', 'not like', '%programmer%');

        $this->paginate();
        $this->layout->toolbar['showTools'] = true;
        $this->layout->content->listBtn['showCheckbox'] = true;
        $this->layout->content->listBtn['showRolePermission'] = true;
    }

    //## create
    public function create($id = 0) {
        $this->layout->title = 'language.new user';

    }

    //## edit
    public function edit($id) {
        $this->layout->title = 'language.user';
        $user = User::find($id);

        $this->layout->content->imageExist = File::exists(config('upload.User') . $id);
        $this->layout->content->signExist = File::exists(config('upload.User') . "/signature/$id");
        if(config('app.theme','cppc') == 'cppc')
            $this->layout->content->authorList = Author::pluck('xauthor_name', 'xauthorid')->prepend('', '');
        
        $this->layout->content->list = $user;

    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $group = Input::get('group');
        $agentId = intval(Input::get('agentId'));

        if ($frm['xxsecurity_user']['xusername'] == '' and !$id) {
            die(trans('language.username and password cannot be empty'));
        }

        $frm['xxsecurity_userinfo']['xbirthday'] = $frm['xxsecurity_userinfo']['xbirthday'] != '0000-00-00' ? FarsiLib::j2gDate($frm['xxsecurity_userinfo']['xbirthday']) : '0000-00-00';

        $id = User::store($frm, $group, $id);

        $this->saveFile($id, [], 'User');
        die('[[OK]]');
    }

    //## delete
    public function delete($id) {
        User::remove($id);
    }

    //## delete image
    public function deleteImg($id) {
        $type = Request::get('type');
        $path = $type == 'signature' ? "signature/$id" : $id;
        File::delete(config('upload.User') . $path);

        die('[[OK]]');
    }

    //############### set combo
    public function setCombo() {
        $groupList = Role::pluck('xname', 'xroleid')->filter(function ($key, $value) {
            return strtolower($key) != 'programmer';
        });

        $this->layout->groupList = $this->layout->content->groupList = $groupList;

        //## user status list
        $this->layout->statusList = $this->layout->content->statusList = User::fetchEnum('xuser_status');

        //## user gender list
        $this->layout->genderList = $this->layout->content->genderList = UserInfo::fetchEnum('xgender');

        $this->layout->content->nowDateTime = date('Y-m-d H:i');
        $this->layout->content->now = date('Y-m-d');
    }

    //## profile
    public function profile() {
        if (Request::ajax()) {
            $this->layout = view('public.profile.overview');
            $this->layout->content = view('backend.ajax');
        } else {
            $this->layout->custom = true;
            $this->layout->content = view('newadmin.layout.component.user._profile');
        }

        $list = Auth::user();
        if ($list) {
            $list['xcreationdate'] = ($list['xcreationdate'] != '0000-00-00 00:00:00' ? FarsiLib::g2jDate($list['xcreationdate'], true) : '');
            $list['xbirthday'] = ($list['xbirthday'] != '0000-00-00' ? FarsiLib::g2jDate($list['xbirthday']) : '');
        }

        $this->layout->lang = $this->layout->content->lang = $this->lang;
        $this->layout->content->list = $list;
        $this->layout->content->nowDateTime = date('Y-m-d H:i');
        $this->layout->content->imageExist = File::exists(config('upload.User') . Auth::id());

        $this->layout->content->signExist = File::exists(config('upload.User') . "/signature/" . Auth::id());

        //## user gender list
        $this->layout->genderList = $this->layout->content->genderList = UserInfo::fetchEnum('xgender');
        
    }

    //## update
    public function updateInfo($id) {
        $userid = Auth::id();
        $frm = Input::get('frm');
        $frm['xxsecurity_userinfo']['xbirthday'] = FarsiLib::j2gDate($frm['xxsecurity_userinfo']['xbirthday']);
        User::store($frm, array_values(Auth::user()->group()), $userid);
        if (Input::file()) {
            $this->saveFile(Auth::id(), [], 'User');
        }
        die(json_encode(['type' => 'success', 'message' => trans('language.information successfully updated')]));
    }

    //## load images
    public function loadImage() {
        $this->layout = view('account::admin.profile.partial.accountImage');

        $this->layout->list = Auth::user();
        $this->layout->imageExist = File::exists(config('upload.User') . Auth::id());
        $this->layout->signExist = File::exists(config('upload.User') . "/signature/" . Auth::id());
    }

    //## change password
    public function changePassword($token) {
        $currentPassword = Input::get('password');
        $newPassword = Input::get('newpassword');
        $retypePassword = Input::get('retypepassword');

        $userRow = User::find(Auth::id());
        if (Session::get('_token') == Input::get('_token')) {
            if (!Hash::check($currentPassword, $userRow->xpassword)) {
                die(json_encode(['type' => 'error', 'message' => trans('language.current password is invalid')]));
            } else if ($newPassword != $retypePassword) {
                die(json_encode(['type' => 'error', 'message' => trans('language.password and confirmation do not match')]));
            } else {
                $userRow->xpayload = Crypt::encrypt($newPassword);
                $userRow->xpassword = Hash::make($newPassword);
                $userRow->save();
                die(json_encode(['type' => 'success', 'message' => trans('language.password successfully changed')]));
            }
        } else {
            die(json_encode(['type' => 'error', 'message' => trans('language.token is invalid')]));
        }
    }

    public function excelExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = User::getResult();
        if (!$checkall && $listchk) {
            $this->list->whereIn('u.xuserid', array_keys($listchk));
        }
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "u.xuserid",
                "direction" => "desc",
            ]];
        }

        return (new UsersExport($this->list))->download('users.xlsx');
    }
}