<?php namespace Modules\Account\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use DB;
use Input;
use Modules\Account\Exports\AgentsExport;
use Modules\Account\Models\Agent;
use Modules\Account\Models\User;

class AgentController extends BackendController {
    public $title = "agent";

    //## list
    //Str::words($item["xvideo_desc"],25);
    //FarsiLib::faNormalizeNumber($item["xevent_price"])
    //FarsiLib::g2jDate($item["xstart"],true);
    //FarsiLib::g2jDate(date('m/d/Y H:i:s',@$list->xcomment_date),true)
    //FarsiLib::j2gDate() convert input from form
    public function index() {
        $this->field[] = ['php' => 'echo \'<div style="text-align: center;"><img src="/pic/user/\' . $item["xuserid"] . "w30h40c1/". rand(1000, 100000) . ".png?nocache=1" . \'" alt="" /></div>\';',
            'name' => trans('language.picture'), 'css' => 'width: 3%'];

        $this->field[] = ['php' => 'echo \'<div style="direction: ltr;">\' . $item["xusername"] . "</div>";', 'name' => trans('language.username'), 'css' => 'width: 10%', 'sortable' => 'xusername'];

        $this->field[] = array('php' => 'echo FarsiLib::faNormalizeNumber($item["xgrand_price"]);', 'name' => @t('grand'), 'css' => 'width: 10%', 'sortable' => 'xstart');

        $this->field[] = array('php' => 'echo FarsiLib::faNormalizeNumber($item["xgrand_consumed"]);', 'name' => @t('grand consumed'), 'css' => 'width: 10%', 'sortable' => 'xstart');

        $this->field[] = array('php' => 'echo FarsiLib::g2jDate($item["expaire_at"],true);', 'name' => @t('end'), 'css' => 'width: 10%', 'sortable' => 'expaire_at');

        $this->list = Agent::getResult();

        $this->paginate();
        $this->layout->toolbar['showTools'] = true;
        $this->layout->content->listBtn['showCheckbox'] = true;

    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Agent::find($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $adv = Agent::updateById($frm, $id);
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Agent::remove($id);

    }

    //## set combo
    public function setCombo() {
        $this->layout->userList = $this->layout->content->userList = User::select(['xusername', 'xuserid'])->pluck('xusername', 'xuserid');
    }

    public function excelExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = Agent::getResult()
            ->select(['u.xusername', 'ag.xgrand_price', 'ag.xgrand_consumed', DB::Raw('PDATE(ag.expaire_at)')]);
        if (!$checkall && $listchk) {
            $this->list->whereIn('ag.xgrandid', array_keys($listchk));
        }
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "ag.xgrandid",
                "direction" => "desc",
            ]];
        }

        return (new AgentsExport($this->list))->download('agents.xlsx');
    }

}